<?php
namespace MetaBox\Support;

class Data {
	public static function get_post_types(): array {
		$unsupported = [
			// WordPress built-in post types.
			'customize_changeset',
			'custom_css',
			'nav_menu_item',
			'oembed_cache',
			'revision',
			'user_request',
			'wp_block',
			'wp_template',
			'wp_template_part',
			'wp_global_styles',
			'wp_navigation',
			'wp_template',
			'wp_template_part',
			'wp_global_styles',
			'wp_font_famlity',
			'wp_font_face',

			// Meta Box post types.
			'mb-post-type',
			'mb-taxonomy',
			'mb-relationship',
			'mb-settings-page',
			'mb-views',
			'meta-box',

			// Elementor post types.
			'elementor_library',
			'elementor_font',
			'elementor_icons',
			'elementor_snippet',
		];
		$post_types = get_post_types( [], 'objects' );
		$post_types = array_diff_key( $post_types, array_flip( $unsupported ) );

		return $post_types;
	}

	public static function get_taxonomies(): array {
		$unsupported = [
			'link_category',
			'nav_menu',
			'post_format',
			'wp_theme',
			'wp_template_part_area',
			'wp_pattern_category',
			'mb-views-category',
		];
		$taxonomies = get_taxonomies( [], 'objects' );
		$taxonomies = array_diff_key( $taxonomies, array_flip( $unsupported ) );

		return $taxonomies;
	}

	public static function get_dashicons(): array {
		return [
			'admin-appearance',
			'admin-collapse',
			'admin-comments',
			'admin-generic',
			'admin-home',
			'admin-links',
			'admin-media',
			'admin-network',
			'admin-page',
			'admin-plugins',
			'admin-post',
			'admin-settings',
			'admin-site',
			'admin-site-alt',
			'admin-site-alt2',
			'admin-tools',
			'admin-users',
			'admin-customizer',
			'admin-multisite',
			'album',
			'align-center',
			'align-left',
			'align-none',
			'align-right',
			'align-full-width',
			'align-pull-left',
			'align-pull-right',
			'align-wide',
			'analytics',
			'archive',
			'arrow-down-alt2',
			'arrow-down-alt',
			'arrow-down',
			'arrow-left-alt2',
			'arrow-left-alt',
			'arrow-left',
			'arrow-right-alt2',
			'arrow-right-alt',
			'arrow-right',
			'arrow-up-alt2',
			'arrow-up-alt',
			'arrow-up',
			'art',
			'awards',
			'amazon',
			'airplane',
			'backup',
			'book-alt',
			'book',
			'block-default',
			'button',
			'building',
			'businessman',
			'bell',
			'beer',
			'bank',
			'car',
			'calendar-alt',
			'calendar',
			'camera',
			'camera-alt',
			'carrot',
			'cart',
			'calculator',
			'category',
			'chart-area',
			'chart-bar',
			'chart-line',
			'chart-pie',
			'clipboard',
			'clock',
			'columns',
			'cover-image',
			'cloud',
			'cloud-saved',
			'cloud-upload',
			'controls-back',
			'controls-forward',
			'controls-pause',
			'controls-play',
			'controls-repeat',
			'controls-skipback',
			'controls-skipforward',
			'controls-volumeoff',
			'controls-volumeon',
			'coffee',
			'dashboard',
			'database-add',
			'database-export',
			'database-import',
			'database-remove',
			'database-view',
			'database',
			'desktop',
			'dismiss',
			'download',
			'drumstick',
			'ellipsis',
			'embed-audio',
			'embed-generic',
			'embed-photo',
			'embed-post',
			'embed-video',
			'editor-aligncenter',
			'editor-alignleft',
			'editor-alignright',
			'editor-bold',
			'editor-break',
			'editor-code',
			'editor-contract',
			'editor-customchar',
			'editor-distractionfree',
			'editor-expand',
			'editor-help',
			'editor-indent',
			'editor-insertmore',
			'editor-italic',
			'editor-justify',
			'editor-kitchensink',
			'editor-ol',
			'editor-outdent',
			'editor-paragraph',
			'editor-paste-text',
			'editor-paste-word',
			'editor-quote',
			'editor-removeformatting',
			'editor-rtl',
			'editor-spellcheck',
			'editor-strikethrough',
			'editor-textcolor',
			'editor-ul',
			'editor-underline',
			'editor-unlink',
			'editor-video',
			'edit',
			'edit-page',
			'email-alt',
			'email',
			'excerpt-view',
			'exerpt-view',
			'external',
			'exit',
			'facebook-alt',
			'facebook',
			'feedback',
			'flag',
			'format-aside',
			'format-audio',
			'format-chat',
			'format-gallery',
			'format-image',
			'format-links',
			'format-quote',
			'format-standard',
			'format-status',
			'format-video',
			'forms',
			'filter',
			'food',
			'fullscreen-alt',
			'fullscreen-exit-alt',
			'games',
			'googleplus',
			'google',
			'grid-view',
			'groups',
			'hammer',
			'heart',
			'heading',
			'html',
			'hourglass',
			'id-alt',
			'id',
			'info-outline',
			'insert-after',
			'insert-before',
			'insert',
			'images-alt2',
			'images-alt',
			'image-crop',
			'image-flip-horizontal',
			'image-flip-vertical',
			'image-rotate-left',
			'image-rotate-right',
			'index-card',
			'info',
			'leftright',
			'lightbulb',
			'list-view',
			'location-alt',
			'location',
			'lock',
			'linkedin',
			'marker',
			'media-archive',
			'media-audio',
			'media-code',
			'media-default',
			'media-document',
			'media-interactive',
			'media-spreadsheet',
			'media-text',
			'media-video',
			'megaphone',
			'menu',
			'menu-alt',
			'menu-alt2',
			'menu-alt3',
			'microphone',
			'migrate',
			'minus',
			'money',
			'money-alt',
			'nametag',
			'networking',
			'no-alt',
			'no',
			'open-folder',
			'palmtree',
			'performance',
			'phone',
			'playlist-audio',
			'playlist-video',
			'plus-alt',
			'plus',
			'portfolio',
			'post-status',
			'post-trash',
			'pressthis',
			'products',
			'plugins-checked',
			'pinterest',
			'podio',
			'printer',
			'pdf',
			'pets',
			'privacy',
			'randomize',
			'redo',
			'rss',
			'remove',
			'reddit',
			'superhero',
			'superhero-alt',
			'spotify',
			'schedule',
			'screenoptions',
			'search',
			'share1',
			'share-alt2',
			'share-alt',
			'share',
			'shield-alt',
			'shield',
			'slides',
			'shortcode',
			'smartphone',
			'smiley',
			'sort',
			'sos',
			'star-empty',
			'star-filled',
			'star-half',
			'store',
			'saved',
			'tablet',
			'twitch',
			'table-col-after',
			'table-col-before',
			'table-col-delete',
			'table-row-after',
			'table-row-before',
			'table-row-delete',
			'tagcloud',
			'tag',
			'testimonial',
			'text',
			'tickets-alt',
			'tickets',
			'translation',
			'trash',
			'twitter',
			'undo',
			'universal-access-alt',
			'universal-access',
			'update',
			'upload',
			'vault',
			'video-alt2',
			'video-alt3',
			'video-alt',
			'visibility',
			'xing',
			'youtube',
			'whatsapp',
			'welcome-add-page',
			'welcome-comments',
			'welcome-edit-page',
			'welcome-learn-more',
			'welcome-view-site',
			'welcome-widgets-menus',
			'welcome-write-blog',
			'wordpress-alt',
			'wordpress',
		];
	}
}