<?php

/**
 * TGM Init Class
 */

include_once get_template_directory() . '/inc/admin/tgm/class-tgm-plugin-activation.php';

function dahotel_register_required_plugins() {

	$plugins = array(
	    array(
				'name' 	   => esc_html__('Redux Framework','dahotel'),
				'slug' 	   => 'redux-framework',
				'required' => true,
		),
		array(
				'name' 	   => esc_html__('Meta Box','dahotel'),
				'slug' 	   => 'meta-box',
				'required' => true,
		),
		array(
			'name' 		  => esc_html__('One Click Demo Import','dahotel'),
			'slug' 		  => 'one-click-demo-import',
			'required' 	=> true,
		),
		array(
			'name' 		  => esc_html__('Contact Form 7','dahotel'),
			'slug' 		  => 'contact-form-7',
			'required' 	=> true,
		),
		array(
			'name' 		  => esc_html__('MailChimp for WordPress','dahotel'),
			'slug' 		  => 'mailchimp-for-wp',
			'required' 	=> true,
		),
		array(
		'name'      => esc_html__('Elementor Page Builder','dahotel'),
		'slug'      => 'elementor',
		'required'  => true,
		),
        
        array(
		'name'      => esc_html__('Recent Posts Widget With Thumbnails','dahotel'),
		'slug'      => 'recent-posts-widget-with-thumbnails',
		'required'  => true,
		),
        
		array(
			'name'      => 'ZD Custom Post Types',
			'slug'      => 'zd-custom-post-types',
			'source'    => 'https://wpdemo.zcubethemes.com/dahotel/wp-content/plugins/zd-custom-post-types.zip',
			'required'  => true,
			'version'   => '1.0.1'
		),		
	);

	$config = array(
		'id'           => 'dahotel',                 // Unique ID for hashing notices for multiple instances of dahotel.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'dahotel-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => true,                    // Automatically activate plugins after installation or not.
		'message'      => '',				   	          // Automatically activate plugins after installation or not
	);

	tgmpa( $plugins, $config );

}
add_action( 'dahotel_register', 'dahotel_register_required_plugins' );
