<?php

if ( ! defined( 'ABSPATH' ) ) exit;

require_once wp_elementor . '/elementor/traits.php';

class dahotel_Elementor_Integration {

	public $widgets;

	public function __construct()
	{
		$this->widgets = [
            
        'header',
        'footer',
        'header-slider',       
        'header-slider-center',       
        'skill',       
        'features',
        'about',      
        'video',      
        'video-two',      
        'price-home',      
        'newsletter',  
        'room', 
        'room-two', 
        'service', 
        'service-one', 
        'service-two', 
        'portfolio', 
        'counter', 
        'team',
        'team-two',     
        'testimonial', 
        'support',   
        'blog', 
        'price',
        'faq',  
        'brand', 
        'contact-sections',       
        'contact-sections-two',       
        'contact-sections-three',       
        'contact-info',       
                
		];
		add_action( 'elementor/init', array( $this, 'widgets_registered' ) );
	}
	public function widgets_registered()
	{
		if ( ! defined( 'ELEMENTOR_PATH' ) || ! class_exists( 'Elementor\Widget_Base' ) || ! class_exists( 'Elementor\Plugin' ) ) {
			return false;
		}

		$elementor = Elementor\Plugin::instance();


		foreach ($this->widgets as $widget) {
			$template_file = wp_elementor . "/elementor/widgets/{$widget}.php";
			if ( file_exists( $template_file ) ) {
				require_once $template_file;
			}
		}
	}
}
new dahotel_Elementor_Integration;