<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class Elementor_About_Box extends Widget_Base {
public function get_name() {
return 'Elementor-About-widget';
}
public function get_title() {
return __( 'Zc >  About' ,'dahotel' );
}
public function get_icon() {
return 'eicon-slider-device';
}
protected function _register_controls() {
$traits = new \dahotel_Elementor_Traits($this);
$this->start_controls_section(
'section_tab', [
'label' =>esc_html__( 'About', 'dahotel' ),
]
);
$this->add_control(
'style', [
'type'         => Controls_Manager::SELECT,
'label'         => esc_html__( 'Choose Style', 'dahotel' ),
'default'     => 'style1',
'label_block'     => true,
'options'     => [
'style1' =>esc_html__( 'About Style 1', 'dahotel' ),
'style2' =>esc_html__( 'About Style 2', 'dahotel' ),
'style3' =>esc_html__( 'About Style 3', 'dahotel' ),
'style4' =>esc_html__( 'Service Box', 'dahotel' ),
'style5' =>esc_html__( 'Why choose us', 'dahotel' ),
'style6' =>esc_html__( 'instagram Box', 'dahotel' ),
                  
],
]
);
$this->add_control(
'icon', [
'label'             =>esc_html__( 'Icon', 'dahotel' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style5'],
],
]
);

$this->add_control(
			'header_background_color',
			[
				'label' => __( 'Background Color Overlay', 'dahotel' ),
				'type' => Controls_Manager::COLOR,
				'condition'      => [
					'style' =>['style12'],
					],
				'selectors' => [
					'{{WRAPPER}} .slider-bg2::before,.slider-bg3::before' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .slider-bg2 .slider-content.second-slider-content::before,.slider-bg2 .slider-content.second-slider-content::after' => 'border-color: {{VALUE}};',
				],
			]
		);
		
		

$this->add_control(
'about_backgrund_images', [
'label'             =>esc_html__( 'Background Image', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style3'],
],
]
);
$this->add_control(
'main_img', [
'label'             =>esc_html__( 'Main Image', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style1','style2','style3'],
],
]
);

$this->add_control(
'ani_image', [
'label'             =>esc_html__( 'Animations Images', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style1','style3'],
],
]
);  
$this->add_control(
'icon_image', [
'label'             =>esc_html__( 'Icon Images', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style1'],
],
]
);  
$this->add_control(
'signature_img', [
'label'             =>esc_html__( 'Signature Images', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style1'],
],
]
);  
$this->add_control(
'text_heading', [
'label'             =>esc_html__( 'Text Heading', 'dahotel' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style1','style2','style3','style5'],
],
]
);    
$this->add_control(
'sub_heading', [
'label'             =>esc_html__( 'Sub Heading', 'dahotel' ),
'type'             => Controls_Manager::TEXT,
'label_block'     => true,
'placeholder'     =>esc_html__( 'dahotel Text', 'dahotel' ),
'default'         =>esc_html__( 'dahotel', 'dahotel' ),
'condition'      => [
'style' =>['style1','style3','style5','style2'],
],
]
);      
    
 $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon Image', 'dahotel' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'heading',
            [
                'label' => esc_html__( 'Heading Text', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Insurance Police',
            ]
        );
        
         $repeater->add_control(
            'description',
            [
                'label' => esc_html__( 'Description Text', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Nullam egestas eros et nulla tempus, vel tempor neque scelerisque. Morbi eleifend convallis turpis, ac scelerisque.',
            ]
        );
        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Title - Active', 'dahotel' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Learn More',                
            ]
        );

        $repeater->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Button Link', 'dahotel' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'dahotel' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

     

        $this->add_control(
            'choose_box_repeater',
            [
                'label' => esc_html__( 'All Choose Box', 'dahotel' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'condition'      => [
                    'style' =>['style5'],
                    ],
                'default' => [
                    [
                          'heading'   => 'Choose Box',
                    ],
                   
                ],
                'title_field' => '{{{heading}}}'
            ]
        );
    
$repeater = new \Elementor\Repeater();
         $repeater->add_control(
            'acitve',
            [
                'label' => esc_html__( 'Class Acitve', 'dahotel' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon Image', 'dahotel' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'heading',
            [
                'label' => esc_html__( 'Heading Text', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Insurance Police',
            ]
        );
        
         $repeater->add_control(
            'price',
            [
                'label' => esc_html__( 'Price Text', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Nullam egestas eros et nulla tempus, vel tempor neque scelerisque. Morbi eleifend convallis turpis, ac scelerisque.',
            ]
        );
        $repeater->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Button Link', 'dahotel' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'dahotel' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

     

        $this->add_control(
            'service_box_repeater',
            [
                'label' => esc_html__( 'All Service Box', 'dahotel' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'condition'      => [
                    'style' =>['style4'],
                    ],
                'default' => [
                    [
                          'heading'   => 'Choose Box',
                    ],
                   
                ],
                'title_field' => '{{{heading}}}'
            ]
        );
    
 $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon Image', 'dahotel' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'feature_img',
            [
                'label' => esc_html__( 'Feature Image', 'dahotel' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
       
        $repeater->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Button Link', 'dahotel' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'dahotel' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

     

        $this->add_control(
            'instagram_repeater',
            [
                'label' => esc_html__( 'All Instagram Box', 'dahotel' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'condition'      => [
                    'style' =>['style6'],
                    ],
             
            ]
        );
    
$this->add_control(
'header_video', [
'label'             =>esc_html__( 'Choose File Video', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style15'],
],
]
);
$this->add_control(
'exp', [
'label'             =>esc_html__( 'Experience', 'dahotel' ),
'type'             => Controls_Manager::TEXTAREA    ,
'condition'      => [
'style' =>['style1'],
],
]
);        
$this->add_control(
'desc_title', [
'label'             =>esc_html__( 'Description', 'dahotel' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'dahotel Text', 'dahotel' ),
'default'         =>esc_html__( 'dahotel', 'dahotel' ),
'condition'      => [
'style' => ['style1','style2']
],
]
);
$this->add_control(
'desc_title1', [
'label'             =>esc_html__( 'Description 1', 'dahotel' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'dahotel Text', 'dahotel' ),
'default'         =>esc_html__( 'dahotel', 'dahotel' ),
'condition'      => [
'style' => ['style1','style2','style3']
],
]
);    
   
$this->add_control(
'slider_button', [
'label'             =>esc_html__( 'Slider Button Text', 'dahotel' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'dahotel Text', 'dahotel' ),
'default'         =>esc_html__( 'Read More', 'dahotel' ),
'condition'      => [
'style' => ['style15']
],
]
);
$this->add_control(
'button_text', [
'label'             =>esc_html__( 'Button Text', 'dahotel' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style1','style3'],
],
]
);
$this->add_control(
'button_link', [
'label'             =>esc_html__( 'Button URL', 'dahotel' ),
'type'             => Controls_Manager::URL,
'condition'      => [
'style' => ['style1','style3'],
],
]
);
$this->add_control(
'button_text1', [
'label'             =>esc_html__( 'Button Text 1', 'dahotel' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style15'],
],
]
);    
$this->add_control(
'button_link1', [
'label'             =>esc_html__( 'Button URL 1', 'dahotel' ),
'type'             => Controls_Manager::URL,
'condition'      => [
'style' => ['style15'],
],
]
);
$this->add_control(
'gal_img_one', [
'label'             =>esc_html__( 'Galler Image One', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style15'],
],
]
);
    $this->add_control(
'gal_img_two', [
'label'             =>esc_html__( 'Galler Image Two', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style15'],
],
]
);
$this->add_control(
'gal_img_three', [
'label'             =>esc_html__( 'Galler Image Three', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style15'],
],
]
);
$this->add_control(
'posts_per_page',
[
'label'   => esc_html__( 'Number of items to show', 'dahotel' ),
'type'    => Controls_Manager::NUMBER,
'default' => 10,
'condition' => [
  'style' => ['style15']  
],
]
);
$this->add_control(
'shortcode',
[
'label' => __( 'Enter your shortcode', 'dahotel' ),
'type' => Controls_Manager::TEXTAREA,
'dynamic' => [
'active' => true,
],
'placeholder' => '[gallery id="123" size="medium"]',
'default' => '',
'condition'      => [
'style' => ['style14']
],
]
);
$this->add_responsive_control(
'title_align', [
'label'             =>esc_html__( 'Alignment', 'dahotel' ),
'type'             => Controls_Manager::CHOOSE,
'options'         => [
'left'         => [
'title'     =>esc_html__( 'Left', 'dahotel' ),
'icon'     => 'fa fa-align-left',
],
'center'     => [
'title'     =>esc_html__( 'Center', 'dahotel' ),
'icon'     => 'fa fa-align-center',
],
'right'         => [
'title'     =>esc_html__( 'Right', 'dahotel' ),
'icon'     => 'fa fa-align-right',
],
'justify'     => [
'title'     =>esc_html__( 'Justified', 'dahotel' ),
'icon'     => 'fa fa-align-justify',
],
],
'default'         => '',
'selectors' => [
'{{WRAPPER}} .inner-item' => 'text-align: {{VALUE}};',
],
]
);
$this->end_controls_section();
 $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'About Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .about-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );
                
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .about-title h2',
            ]
        );
    
        $this->add_control(
            'color_decriptions', [
                'label' => esc_html__( 'Decriptions Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .s-about-content p' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'about_content_one', [
                'label' => esc_html__( 'Ul li Text Color - Active', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-content li' => 'color: {{VALUE}};',
                ],
            ]
        );
         $this->add_control(
            'about_content_three', [
                'label' => esc_html__( 'Ul li Before Text Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-content3 li::before' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'about_content_two', [
                'label' => esc_html__( 'Ul li Before Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-content3 li::before' => 'background: {{VALUE}};',
                ],
            ]
        );

    
        $this->end_controls_section();
}
protected function render( $instance = [] ) {
$settings = $this->get_settings();
$style = $settings[ 'style' ];
$about_backgrund_images = $settings[ 'about_backgrund_images' ];    
$main_img = $settings[ 'main_img' ];    
$icon_image = $settings[ 'icon_image' ];
$text_heading = $settings[ 'text_heading' ];
$sub_heading = $settings[ 'sub_heading' ];
$exp = $settings[ 'exp' ];
$desc_title = $settings[ 'desc_title' ];
$desc_title1 = $settings[ 'desc_title1' ];
$slider_button = $settings[ 'slider_button' ];
$icon = $settings[ 'icon' ];
$button_text = $settings[ 'button_text' ];
$button_link = $settings[ 'button_link' ];
$button_text1 = $settings[ 'button_text1' ];
$button_link1 = $settings[ 'button_link1' ];
$shortcode = $settings[ 'shortcode' ];
$posts_per_page = $settings['posts_per_page'];
$header_video = $settings[ 'header_video' ];
$gal_img_one = $settings[ 'gal_img_one' ];
$gal_img_two = $settings[ 'gal_img_two' ];
$gal_img_three = $settings[ 'gal_img_three' ];
$ani_image = $settings[ 'ani_image' ];
$signature_img = $settings[ 'signature_img' ];
$choose_box_repeater = $settings[ 'choose_box_repeater' ];
$service_box_repeater = $settings[ 'service_box_repeater' ];
$instagram_repeater = $settings[ 'instagram_repeater' ];

switch ( $style ) {
case 'style1':
require get_template_directory() . '/inc/sections/about/style1.php';
break;
case 'style2':
require get_template_directory() . '/inc/sections/about/style2.php';
break;
case 'style3':
require get_template_directory() . '/inc/sections/about/style3.php';
break;
case 'style4':
require get_template_directory() . '/inc/sections/about/style4.php';
break;
case 'style5':
require get_template_directory() . '/inc/sections/about/style5.php';
break;
case 'style6':
require get_template_directory() . '/inc/sections/about/style6.php';
break;
}
}
protected function content_template() {}
public function render_plain_content() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Elementor_About_Box() );