<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'Elementor-contact-info';
	}

	public function get_title() {
		return __( 'Zc >  Contact Info' ,'dahotel' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \dahotel_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Contact Info','dahotel'),]
		);
        
        $this->add_control(

			'text_heading',
                [

                    'label' => esc_html__( 'Heading' ,'dahotel'),
                    'type' => Controls_Manager::TEXT,
                ]
			);
        $this->add_control(

			'shortcode',
                [

                    'label' => esc_html__( 'Contact Form' ,'dahotel'),
                    'type' => Controls_Manager::TEXTAREA,
                ]
			);
		$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','dahotel'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					
					[                    
						'name' => 'icon',
						'label' => esc_html__( 'Icon' ,'dahotel' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [                    
						'name' => 'text',
						'label' => esc_html__( 'Heading' ,'dahotel' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [                    
						'name' => 'content',
						'label' => esc_html__( 'Content' ,'dahotel' ),
						'type' => Controls_Manager::TEXTAREA,
					],
                              
				],
			]
		);
         
		$this->end_controls_section();
        $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'Contact Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );
                
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .section-title h2',
            ]
        );
        
        $this->add_control(
            'about_content_one', [
                'label' => esc_html__( 'Btn Text Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                   '{{WRAPPER}} .contact-area li span.active' => 'color: {{VALUE}};',
                   '{{WRAPPER}} .contact-area li span:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'about_content_two', [
                'label' => esc_html__( 'Btn Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                   '{{WRAPPER}} .contact-area li span' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'about_content_three', [
                'label' => esc_html__( 'Btn Active Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                   '{{WRAPPER}} .contact-area li span:hover' => 'background: {{VALUE}};',
                   '{{WRAPPER}} .contact-area li span.active' => 'background: {{VALUE}};',
                   '{{WRAPPER}}  .btn.ss-btn' => 'background: {{VALUE}};',
                ],
            ]
        );
    
        $this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		dahotel_el()->get_section('contact-info', [
            
			'service_section_var' => $this->get_settings('service_section'),
			'column_section_data' => $this->get_settings('column_section'),
            'text_heading' => $this->get_settings('text_heading'),
			'shortcode' => $this->get_settings('shortcode'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Contact_Info() );