<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_counter_box extends Widget_Base {

	public function get_name() {
		return 'Elementor-counter-widget';
	}

	public function get_title() {
		return __( 'Zc >  Counter Box' ,'dahotel' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \dahotel_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Counter','dahotel'),]
		);
        
  
		$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','dahotel'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
                    
					[                    
						'name' => 'increment',
						'label' => esc_html__( 'increment' ,'dahotel' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [                    
						'name' => 'sumble',
						'label' => esc_html__( 'Sumble' ,'dahotel' ),
						'type' => Controls_Manager::TEXT,
					],
                                        
                    [					
						'name' => 'text',
						'label' => esc_html__( 'Content','dahotel'),
						'type' => Controls_Manager::TEXTAREA,
					],
					
				],
			]
		);
         
		$this->end_controls_section();
        
        $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'Counter Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .counter span' => 'color: {{VALUE}};',
                ],
            ]
        );
                
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .count',
            ]
        );
    
        $this->add_control(
            'color_decriptions', [
                'label' => esc_html__( 'Decriptions Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-area .container p' => 'color: {{VALUE}};',
                ],
            ]
        );
        
      

    
        $this->end_controls_section();
        
	}

	protected function render( $instance = [] ) {

		dahotel_el()->get_section('counter', [
            
			'service_section_var' => $this->get_settings('service_section'),
			'column_section_data' => $this->get_settings('column_section'),			
			
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_counter_box() );