<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_faq extends Widget_Base {

	public function get_name() {
		return 'Elementor_faq';
	}

	public function get_title() {
		return esc_html__( 'Zc > Faq','dahotel');
	}

	public function get_icon() {
		
		 return 'eicon-image-box';
	 }

	protected function _register_controls() {
		$traits = new \dahotel_Elementor_Traits($this);

		$this->start_controls_section(
			'the_why_choose_controls',
			['label' => esc_html__( 'Faq Section','dahotel'),]
		);
        
        
         $this->add_control(

			'main_img',

                [
                    'label' => esc_html__( 'Background Image' ,'dahotel'),
                    'type' => Controls_Manager::MEDIA,
                ]

			);
        
			$this->add_control(

			'service_section',

			[

				'label' => esc_html__( 'Repeator Text','dahotel'),

				'type' => Controls_Manager::REPEATER,

				'fields' => [
                    [

						'name' => 'text-id',

						'label' => esc_html__( 'Tab id ' ,'dahotel' ),

						'type' => Controls_Manager::TEXT,

					],
						 
                    [

						'name' => 'collapsed-class',

						'label' => esc_html__( 'Collapsed Class' ,'dahotel' ),

						'type' => Controls_Manager::TEXT,

					],
                    [

						'name' => 'active-class',

						'label' => esc_html__( 'Active Class' ,'dahotel' ),

						'type' => Controls_Manager::TEXT,

					],
					[

						'name' => 'text',

						'label' => esc_html__( 'Text' ,'dahotel' ),

						'type' => Controls_Manager::TEXT,

					],

					[

						'name' => 'content',

						'label' => esc_html__( 'Content','dahotel'),

						'type' => Controls_Manager::TEXTAREA,

					],
					

				],

			]

		);
       
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {


		dahotel_el()->get_section('faq', [
			'main_img' => $this->get_settings('main_img'),
			'icon_img' => $this->get_settings('icon_img'),
			'sub_heading' => $this->get_settings('sub_heading'),
			'text_heading' => $this->get_settings('text_heading'),
			'service_section_var' => $this->get_settings('service_section'),
			'clogo_repeater' => $this->get_settings('clogo_repeater'),
			'text_heading_two' => $this->get_settings('text_heading_two'),
                   
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_faq() );
