<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_features_box extends Widget_Base {

	public function get_name() {
		return 'Elementor-features-widget';
	}

	public function get_title() {
		return __( 'Zc >  Features Box' ,'dahotel' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \dahotel_Elementor_Traits($this);
		
	        
         $this->start_controls_section(
            'hero_section_heading',
            [
                'label' => esc_html__( 'Feature - Box', 'dahotel' ),
            ]
        );      

        $repeater = new \Elementor\Repeater();

         $repeater->add_control(
            'feature_image',
            [
                'label' => esc_html__( 'Feature Image', 'dahotel' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'heading',
            [
                'label' => esc_html__( 'Heading Text', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Insurance Police',
            ]
        );
        
        $this->add_control(
            'feature_box_repeater',
            [
                'label' => esc_html__( 'All Slides', 'dahotel' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                          'heading'   => 'Insurance Police',
                    ],
                   
                ],
                'title_field' => '{{{heading}}}'
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'Feature Box Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .services-box01 h5' => 'color: {{VALUE}};',
                ],
            ]
        );
                
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .services-box01 h5',
            ]
        );
    
        $this->add_control(
            'color_decriptions', [
                'label' => esc_html__( 'Decriptions Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-box01 p' => 'color: {{VALUE}};',
                ],
            ]
        );
      
        $this->add_control(
            'about_content_two', [
                'label' => esc_html__( 'Link and Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-box01 h5::before' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .hover-underline-animation::after' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .services-box01 a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'about_content_one', [
                'label' => esc_html__( 'Number Text Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-box01 .number' => 'color: {{VALUE}};',
                ],
            ]
        );
    
        $this->end_controls_section();
        
	}

	protected function render( $instance = [] ) {

		dahotel_el()->get_section('features', [
            'feature_box_repeater' => $this->get_settings('feature_box_repeater'),
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_features_box() );