<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Widget_header_slider extends Widget_Base {

	public function get_name() {
		return 'Elementor-Widget-header-slider';
	}

	public function get_title() {
		return esc_html__( 'Zc > Header Slider', 'dahotel' );
	}

	public function get_icon() {
		return 'eicon-slider-device';
	}

	protected function _register_controls() {
		$traits = new \dahotel_Elementor_Traits($this);
        
         $this->start_controls_section(
            'hero_section_heading',
            [
                'label' => esc_html__( 'Slider - Hero', 'dahotel' ),
            ]
        );
        
      
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'hero_image', [
                'label' => esc_html__( 'Slide Background Image', 'dahotel' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                ],
            ]
        );

        $repeater->add_control(
            'hero_heading',
            [
                'label' => esc_html__( 'Heading Text', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Enjoy A Luxuary Experience',
            ]
        );
        
         $repeater->add_control(
            'hero_description',
            [
                'label' => esc_html__( 'Description Text', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Donec vitae libero non enim placerat eleifend aliquam erat volutpat. Curabitur diam ex, dapibus purus sapien, cursus sed nisl tristique, commodo gravida lectus non.',
            ]
        );
        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Title - Active', 'dahotel' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Discover More',                
            ]
        );

        $repeater->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Button Link', 'dahotel' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'dahotel' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );
        $repeater->add_control(
            'button_text_two',
            [
                'label' => esc_html__( 'Video Button Title - Active', 'dahotel' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Intro Video',                
            ]
        );

        $repeater->add_control(
            'button_link_two',
            [
                'label' => esc_html__( 'Video Button Link', 'dahotel' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'dahotel' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

     

        $this->add_control(
            'hero_slides',
            [
                'label' => esc_html__( 'All Slides', 'dahotel' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'hero_image' => [
                            'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                        ],
                        'hero_heading'   => 'Enjoy A Luxuary Experience',
                    ],
                   
                ],
                'title_field' => '{{{hero_heading}}}'
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'Slide Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .slider-content h2' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'color_heading_span', [
                'label' => esc_html__( 'Heading Span Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .slider-content h2 span' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .slider-content h2',
            ]
        );

        $this->add_control(
            'color_subheading', [
                'label' => esc_html__( 'Sub Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-content h5' => 'color: {{VALUE}};',
                ],
            ]
        );
          $this->add_control(
            'color_subheading_span', [
                'label' => esc_html__( 'Heading Span Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .slider-content h5 span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_subheading',
                'selector' => '{{WRAPPER}} .slider-content h5',
            ]
        );
        $this->add_control(
            'color_decriptions', [
                'label' => esc_html__( 'Decriptions Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-content p' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'button_color1', [
                'label' => esc_html__( 'Button Text Color - Active', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn.ss-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color1', [
                'label' => esc_html__( 'Button Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn.ss-btn' => 'background: {{VALUE}};',
                ],
            ]
        );

    
        $this->end_controls_section();
		
	}

	protected function render( $instance = [] ) {

		dahotel_el()->get_section('header-slider', [
			'hero_slides' => $this->get_settings('hero_slides'),
		
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Widget_header_slider() );