<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class Elementor_Header_box extends Widget_Base {
public function get_name() {
return 'Elementor-Header-widget';
}
public function get_title() {
return __( 'Zc >  Header' ,'dahotel' );
}
public function get_icon() {
return 'eicon-slider-device';
}
protected function _register_controls() {
$traits = new \dahotel_Elementor_Traits($this);
$this->start_controls_section(
'section_tab', [
'label' =>esc_html__( 'Header', 'dahotel' ),
]
);
$this->add_control(
'style', [
'type'         => Controls_Manager::SELECT,
'label'         => esc_html__( 'Choose Style', 'dahotel' ),
'default'     => 'style1',
'label_block'     => true,
'options'     => [
'style1' =>esc_html__( 'Header Style 1', 'dahotel' ),
'style3' =>esc_html__( 'Header Style 2', 'dahotel' ),
'style2' =>esc_html__( 'Booking Form', 'dahotel' ),


],
]
);
$this->add_control(
'icon', [
'label'             =>esc_html__( 'Icon', 'dahotel' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style5'],
],
]
);

$this->add_control(
        'header_background_color',
        [
            'label' => __( 'Background Color Overlay', 'dahotel' ),
            'type' => Controls_Manager::COLOR,
            'condition'      => [
                'style' =>['style2','style3'],
                ],
            'selectors' => [
                '{{WRAPPER}} .slider-bg2::before,.slider-bg3::before' => 'background-color: {{VALUE}};',
                '{{WRAPPER}} .slider-bg2 .slider-content.second-slider-content::before,.slider-bg2 .slider-content.second-slider-content::after' => 'border-color: {{VALUE}};',
            ],
        ]
    );

$this->add_control(
'background_text', [
'label'             =>esc_html__( 'Header Background Text', 'dahotel' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style11'],
],
]
);    
$this->add_control(
'header_image', [
'label'             =>esc_html__( 'Header Image', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style1','style3'],
],
]
);
$this->add_control(
'header_backgrund_images', [
'label'             =>esc_html__( 'Ani Bg one', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style11'],
],
]
);
$this->add_control(
'header_images', [
'label'             =>esc_html__( 'Ani Bg Two', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style11'],
],
]
);
$this->add_control(
'header_images_three', [
'label'             =>esc_html__( 'Ani Bg Three', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style11'],
],
]
);
$this->add_control(
'header_images_four', [
'label'             =>esc_html__( 'Ani Bg Four', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style11'],
],
]
);
$this->add_control(
'header_video', [
'label'             =>esc_html__( 'Choose File Video', 'dahotel' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style13'],
],
]
);
$this->add_control(
'title_text', [
'label'             =>esc_html__( 'Heading ', 'dahotel' ),
'type'             => Controls_Manager::TEXT,
'label_block'     => true,
'placeholder'     =>esc_html__( 'Featured Products', 'dahotel' ),
'default'         =>esc_html__( 'Featured', 'dahotel' ),
'condition'      => [
'style' =>['style1','style3'],
],
]
);
$this->add_control(
'sub_title', [
'label'             =>esc_html__( 'Heading Sub Title', 'dahotel' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'dahotel Text', 'dahotel' ),
'default'         =>esc_html__( 'dahotel', 'dahotel' ),
'condition'      => [
'style' =>['style1','style3'],
],
]
);
$this->add_control(
'desc_title', [
'label'             =>esc_html__( 'Description', 'dahotel' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'dahotel Text', 'dahotel' ),
'default'         =>esc_html__( 'dahotel', 'dahotel' ),
'condition'      => [
'style' => ['style1','style3']
],
]
);
$this->add_control(
'short_code', [
'label'             =>esc_html__( 'Contact Short Code', 'dahotel' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'dahotel Text', 'dahotel' ),
'default'         =>esc_html__( 'dahotel', 'dahotel' ),
'condition'      => [
'style' => ['style2']
],
]
);
$this->add_control(
'slider_button', [
'label'             =>esc_html__( 'Slider Button Text', 'dahotel' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'dahotel Text', 'dahotel' ),
'default'         =>esc_html__( 'Read More', 'dahotel' ),
'condition'      => [
'style' => ['style13']
],
]
);
$this->add_control(
'button_text', [
'label'             =>esc_html__( 'Button Text', 'dahotel' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>[ 'style1','style3'],
],
]
);
$this->add_control(
'button_link', [
'label'             =>esc_html__( 'Button URL', 'dahotel' ),
'type'             => Controls_Manager::URL,
'condition'      => [
'style' => ['style1','style3'],
],
]
);
$this->add_control(
'button_text_contact', [
'label'             =>esc_html__( 'Button Text Contact', 'dahotel' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style1','style3'],
],
]
); 
$this->add_control(
'button_link_contact', [
'label'             =>esc_html__( 'Button URL Contact', 'dahotel' ),
'type'             => Controls_Manager::URL,
'condition'      => [
'style' => ['style1','style3'],
],
]
);

$this->add_control(
'shortcodeing',
[
'label' => __( 'Enter your shortcode', 'dahotel' ),
'type' => Controls_Manager::TEXTAREA,
'dynamic' => [
'active' => true,
],
'placeholder' => '[gallery id="123" size="medium"]',
'default' => '',
'condition'      => [
'style' => ['style1']
],
]
);
$this->add_responsive_control(
'title_align', [
'label'             =>esc_html__( 'Alignment', 'dahotel' ),
'type'             => Controls_Manager::CHOOSE,
'options'         => [
'left'         => [
'title'     =>esc_html__( 'Left', 'dahotel' ),
'icon'     => 'fa fa-align-left',
],
'center'     => [
'title'     =>esc_html__( 'Center', 'dahotel' ),
'icon'     => 'fa fa-align-center',
],
'right'         => [
'title'     =>esc_html__( 'Right', 'dahotel' ),
'icon'     => 'fa fa-align-right',
],
'justify'     => [
'title'     =>esc_html__( 'Justified', 'dahotel' ),
'icon'     => 'fa fa-align-justify',
],
],
'default'         => '',
'selectors' => [
'{{WRAPPER}} .inner-item' => 'text-align: {{VALUE}};',
],
]
);
$this->end_controls_section();
    
 $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'Slide Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .slider-content h2' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'color_heading_span', [
                'label' => esc_html__( 'Heading Span Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .slider-content h4 span' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .slider-content h2',
            ]
        );

        $this->add_control(
            'color_subheading', [
                'label' => esc_html__( 'Sub Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-content h5' => 'color: {{VALUE}};',
                ],
            ]
        );
          $this->add_control(
            'color_subheading_span', [
                'label' => esc_html__( 'Heading Span Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .slider-content h5 span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_subheading',
                'selector' => '{{WRAPPER}} .slider-content h5',
            ]
        );
        $this->add_control(
            'color_decriptions', [
                'label' => esc_html__( 'Decriptions Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-content p' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'button_color1', [
                'label' => esc_html__( 'Button Text Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn.ss-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color1', [
                'label' => esc_html__( 'Button Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn.ss-btn' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_color2', [
                'label' => esc_html__( 'Button Text Color - Active', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn.ss-btn.active' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color2', [
                'label' => esc_html__( 'Button Background Two Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn.ss-btn.active' => 'background: {{VALUE}};',
                ],
            ]
        );
    
        $this->end_controls_section();
}
protected function render( $instance = [] ) {
$settings = $this->get_settings();
$style = $settings[ 'style' ];
$title_text = $settings[ 'title_text' ];
$sub_title = $settings[ 'sub_title' ];
$desc_title = $settings[ 'desc_title' ];
$slider_button = $settings[ 'slider_button' ];
$header_backgrund_images = $settings[ 'header_backgrund_images' ];
$background_text = $settings[ 'background_text' ];
$header_image = $settings[ 'header_image' ];
$header_images = $settings[ 'header_images' ];
$icon = $settings[ 'icon' ];
$button_text = $settings[ 'button_text' ];
$button_text_contact = $settings[ 'button_text_contact' ];
$button_link = $settings[ 'button_link' ];
$button_link_contact = $settings[ 'button_link_contact' ];
$header_video = $settings[ 'header_video' ];
$header_images_three = $settings[ 'header_images_three' ];
$header_images_four = $settings[ 'header_images_four' ];
$short_codeing = $settings[ 'shortcodeing' ];
$short_code = $settings[ 'short_code' ];

switch ( $style ) {
case 'style1':
require get_template_directory() . '/inc/sections/header/style1.php';
break;
case 'style2':
require get_template_directory() . '/inc/sections/header/style2.php';
break;
case 'style3':
require get_template_directory() . '/inc/sections/header/style3.php';
break;
}
}
protected function content_template() {}
public function render_plain_content() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Header_box() );