<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_price_home_widget extends Widget_Base {

	public function get_name() {
		return 'Elementor-price-home';
	}

	public function get_title() {
		return esc_html__( 'Zc > Home Price' ,'dahotel');
	}

	public function get_icon() {
		
		return 'eicon-price-table';
	}

	protected function _register_controls() {
		$traits = new \dahotel_Elementor_Traits($this);
		
		$this->start_controls_section(
			'price-icon-control',
			['label' => esc_html__( 'Price Section','dahotel'),]
		);
        $this->add_control(

			'ani_bg',
			[
				'label' => esc_html__( 'Animations Image' ,'dahotel'),
				'type' => Controls_Manager::MEDIA,
			]
			);
        
        $this->add_control(

			'ani_bg_two',
			[
				'label' => esc_html__( 'Animations Image Two' ,'dahotel'),
				'type' => Controls_Manager::MEDIA,
			]
			);

          $this->add_control(

			'text_heading',
			[
				'label' => esc_html__( 'Text Heading' ,'dahotel'),
				'type' => Controls_Manager::TEXT,
			]
			);
        $this->add_control(

			'sub_heading',
			[
				'label' => esc_html__( 'Sub Heading' ,'dahotel'),
				'type' => Controls_Manager::TEXTAREA,
			]
			);
        $this->add_control(

			'decrip',
			[
				'label' => esc_html__( 'Description' ,'dahotel'),
				'type' => Controls_Manager::TEXTAREA,
			]
			);
		$this->add_control(
			'Repeator',
			[
				'label' => esc_html__( 'Price Icon','dahotel'),
				'type' => Controls_Manager::REPEATER,
				'fields' =>array_merge([
                    
                  [
						'name' => 'active_changer',
					   'label' => esc_html__( 'active', 'dahotel'),
					   'type' => Controls_Manager::SELECT2,
					   'default' => 'd-active',
					   'options' => [
						'd-active' => esc_html__( 'D-Active', 'dahotel'),
						'active' => esc_html__( 'Active', 'dahotel'),

                        ],

                    ],

                   [
                        'name' => 'text',
                        'label' => esc_html__( 'Text' ,'dahotel' ),
                        'type' => Controls_Manager::TEXT,

                    ],	
				     [
                        'name' => 'ptext',
                        'label' => esc_html__( 'Paragraph Text' ,'dahotel' ),
                        'type' => Controls_Manager::TEXT,

                    ],	
				
                    [
						'name' => 'price',
						'label' => esc_html__( 'price','dahotel'),
						'type' => Controls_Manager::TEXT,
					],
				    
                     [
						'name' => 'price_text',
						'label' => esc_html__( 'Price Text','dahotel'),
						'type' => Controls_Manager::TEXTAREA,
					],
                    
                    [
						'name' => 'content',
						'label' => esc_html__( 'content' ,'dahotel'),
						'type' => Controls_Manager::TEXTAREA,
					],
                    
					[

						'name' => 'price-button',

						'label' => esc_html__( 'Price Button Text' ,'dahotel'),

						'type' => Controls_Manager::TEXT,

					],
					
					[

						'name' => 'price-button-link',

						'label' => esc_html__( 'url' ,'dahotel'),

						'type' => Controls_Manager::URL,

						'default' => [

							'url' => '',

							'is_external' => true,

						],

						'show_external' => false,

						'separator' => 'after',

					],
					
				]),
			]
		);
         
		$this->end_controls_section();
        
         $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'Pricing Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Price Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );
                
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .section-title h2',
            ]
        );
    
        $this->add_control(
            'color_decriptions', [
                'label' => esc_html__( 'Decriptions Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );        
    
        $this->add_control(
            'about_content_one', [
                'label' => esc_html__( 'Pricing Text And Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                   '{{WRAPPER}} .pricing-box2.active' => 'background: {{VALUE}};',
                   '{{WRAPPER}} .pricing-btn .btn' => 'background: {{VALUE}};',
                   '{{WRAPPER}} .price-count h2' => 'color: {{VALUE}};',
                   '{{WRAPPER}} .pricing-body li::before' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .pricing-box.active .pricing-btn .btn' => 'color: {{VALUE}};',
                ],
            ]
        );
         $this->add_control(
            'about_content_two', [
                'label' => esc_html__( 'Pricing Active Text And Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                   '{{WRAPPER}} .pricing-box.active .pricing-btn .btn' => 'background: {{VALUE}};',
                   '{{WRAPPER}} .pricing-box2.active .price-count h2' => 'color: {{VALUE}};',
                   '{{WRAPPER}} .pricing-box2.active .pricing-head h3' => 'color: {{VALUE}};',
                   '{{WRAPPER}} .pricing-box2.active .pricing-body li::before' => 'color: {{VALUE}};',
                ],
            ]
        );
    
        $this->end_controls_section();
		
	}

	protected function render( $instance = [] ) {

		dahotel_el()->get_section('price-home', [
            
			'Repeators' => $this->get_settings('Repeator'),
            'text_heading' => $this->get_settings('text_heading'),
            'sub_heading' => $this->get_settings('sub_heading'),
            'ani_bg' => $this->get_settings('ani_bg'),
            'ani_bg_two' => $this->get_settings('ani_bg_two'),
            'decrip' => $this->get_settings('decrip'),
	       
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_price_home_widget() );