<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_price_icon_widget extends Widget_Base {

	public function get_name() {
		return 'Elementor-price-icon';
	}

	public function get_title() {
		return esc_html__( 'Zc > Price' ,'dahotel');
	}

	public function get_icon() {
		
		return 'eicon-price-table';
	}

	protected function _register_controls() {
		$traits = new \dahotel_Elementor_Traits($this);
		
		$this->start_controls_section(
			'price-icon-control',
			['label' => esc_html__( 'Price Section','dahotel'),]
		);
         $this->add_control(

			'ani_bg',
			[
				'label' => esc_html__( 'Animations Image' ,'dahotel'),
				'type' => Controls_Manager::MEDIA,
			]
			);
         $this->add_control(

			'sub_heading',
			[
				'label' => esc_html__( 'Sub Heading' ,'dahotel'),
				'type' => Controls_Manager::TEXT,
			]
			);
         $this->add_control(
            
		  'show_sub_heading', [
            'label' => esc_html__('Show Sub Heading', 'dahotel' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Show', 'dahotel' ),
            'label_off' => esc_html__( 'Hide', 'dahotel' ),
            'return_value' => 'yes',
            'default' => 'yes',                
            ]
            
			);
          $this->add_control(

			'text_heading',
			[
				'label' => esc_html__( 'Text Heading' ,'dahotel'),
				'type' => Controls_Manager::TEXT,
			]
			);
        $this->add_control(
            
		  'show_text_heading', [
            'label' => esc_html__('Show Text Heading', 'dahotel' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Show', 'dahotel' ),
            'label_off' => esc_html__( 'Hide', 'dahotel' ),
            'return_value' => 'yes',
            'default' => 'yes',                
            ]
            
			);
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'price_active_changer',     
                  [
						'name' => 'active_changer',
					   'label' => esc_html__( 'active', 'dahotel'),
					   'type' => Controls_Manager::SELECT2,
					   'default' => 'd-active',
					   'options' => [
						'd-active' => esc_html__( 'D-Active', 'dahotel'),
						'active' => esc_html__( 'Active', 'dahotel'),
                        ],

            ]
        );
        
        $repeater->add_control(
            'price_image', [
                'label' => esc_html__( 'Icon', 'dahotel' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                ],
            ]
        );
        $repeater->add_control(
            'price_sub_heading',
            [
                'label' => esc_html__( 'Sub Heading Text', 'dahotel' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Enjoy A Luxuary Experience',
            ]
        );
        $repeater->add_control(
            'price_amount',
            [
                'label' => esc_html__( 'Price Amount', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => '99',
            ]
        );
        $repeater->add_control(
            'price_month',
            [
                'label' => esc_html__( 'Price Month', 'dahotel' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '/ Per Night',
            ]
        );
         $repeater->add_control(
            'price_description',
            [
                'label' => esc_html__( 'Description Text', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Donec vitae libero non enim placerat eleifend aliquam erat volutpat. Curabitur diam ex, dapibus purus sapien, cursus sed nisl tristique, commodo gravida lectus non.',
            ]
        );
        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Title - Active', 'dahotel' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Discover More',                
            ]
        );

        $repeater->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Button Link', 'dahotel' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'dahotel' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );
       

        $this->add_control(
            'price_slides',
            [
                'label' => esc_html__( 'All Price Slides', 'dahotel' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'price_image' => [
                            'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                        ],
                        'price_heading'   => 'Enjoy A Luxuary Experience',
                    ],
                   
                ],
                'title_field' => '{{{price_sub_heading}}}'
            ]
        );
        
         
		$this->end_controls_section();
        
         $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'Pricing Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Price Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );
                
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .section-title h2',
            ]
        );
    
        $this->add_control(
            'color_decriptions', [
                'label' => esc_html__( 'Decriptions Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );        
    
        $this->add_control(
            'about_content_one', [
                'label' => esc_html__( 'Pricing Text And Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                   '{{WRAPPER}} .pricing-box.active' => 'background: {{VALUE}};',
                   '{{WRAPPER}} .pricing-btn .btn' => 'background: {{VALUE}};',
                   '{{WRAPPER}} .price-count h2' => 'color: {{VALUE}};',
                   '{{WRAPPER}} .pricing-body li::before' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .pricing-box.active .pricing-btn .btn' => 'color: {{VALUE}};',
                ],
            ]
        );
         $this->add_control(
            'about_content_two', [
                'label' => esc_html__( 'Pricing Active Text And Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                   '{{WRAPPER}} .pricing-box.active .pricing-btn .btn' => 'background: {{VALUE}};',
                   '{{WRAPPER}} .pricing-box.active .price-count h2' => 'color: {{VALUE}};',
                   '{{WRAPPER}} .pricing-box.active .pricing-head h3' => 'color: {{VALUE}};',
                   '{{WRAPPER}} .pricing-box.active .pricing-body li::before' => 'color: {{VALUE}};',
                ],
            ]
        );
    
        $this->end_controls_section();
		
	}

	protected function render( $instance = [] ) {

		dahotel_el()->get_section('price', [
            
			'ani_bg' => $this->get_settings('ani_bg'),
			'price_slides' => $this->get_settings('price_slides'),
            'text_heading' => $this->get_settings('text_heading'),
            'show_text_heading' => $this->get_settings('show_text_heading'),
            'sub_heading' => $this->get_settings('sub_heading'),
            'show_sub_heading' => $this->get_settings('show_sub_heading'),
	       
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_price_icon_widget() );