<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_room_box extends Widget_Base {

	public function get_name() {
		return 'Elementor-room-widget';
	}

	public function get_title() {
		return __( 'Zc >  Room Box' ,'dahotel' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \dahotel_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Room Section','dahotel'),]
		);
        
       $this->add_control(
             
			'ani_img',
			[

				'label' => esc_html__( 'Animations Bg' ,'dahotel'),
				'type' => Controls_Manager::MEDIA,
			]
			);
        
         $this->add_control(
             
			'sub_heading',
			[

				'label' => esc_html__( 'Sub Heading' ,'dahotel'),
				'type' => Controls_Manager::TEXT,
			]
			);
        
        
         $this->add_control(
             
			'text_heading',

			[
				'label' => esc_html__( 'Text Heading' ,'dahotel'),
				'type' => Controls_Manager::TEXT,
			]
			);
        $this->add_control(
             
			'text_decr',

			[
				'label' => esc_html__( 'Description Heading' ,'dahotel'),
				'type' => Controls_Manager::TEXTAREA,
			]
			);
		$this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of items to show', 'dahotel' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
			]
		);
        
         
		$this->end_controls_section();
        
        $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'Services Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .services-05 h2' => 'color: {{VALUE}};',
                ],
            ]
        );
                
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .services-05 h2',
            ]
        );
    
        $this->add_control(
            'color_decriptions', [
                'label' => esc_html__( 'Text Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-box-02 .services-content2 p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .services-box-02 .services-content2 h4' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .services-box-02 .services-content2 .link' => 'color: {{VALUE}};',
                ],
            ]
        );
        
         $this->add_control(
            'about_content_one', [
                'label' => esc_html__( 'BG Text Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-05 .text-bg h2' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'about_content_two', [
                'label' => esc_html__( 'Dots Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-active .slick-dots li.slick-active button' => 'background: {{VALUE}};',
                ],
            ]
        );

    
        $this->end_controls_section();
        
	}

	protected function render( $instance = [] ) {

		dahotel_el()->get_section('room', [
            
			'service_section_var' => $this->get_settings('service_section'),
			'ani_img' => $this->get_settings('ani_img'),
			'sub_heading' => $this->get_settings('sub_heading'),
			'text_heading' => $this->get_settings('text_heading'),
			'text_decr' => $this->get_settings('text_decr'),
			'posts_per_page' => $this->get_settings('posts_per_page'),

			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_room_box() );