<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_service_two_box extends Widget_Base {

	public function get_name() {
		return 'Elementor-service-two-widget';
	}

	public function get_title() {
		return __( 'Zc >  Service Two Box' ,'dahotel' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \dahotel_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Service One Section','dahotel'),]
		);
        $this->add_control(

			'text_heading',
			[
				'label' => esc_html__( 'Text Heading' ,'dahotel'),
				'type' => Controls_Manager::TEXT,
			]
			);
        
		$this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of items to show', 'dahotel' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
			]
		);
        
         
		$this->end_controls_section();
        
        $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'Services Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                     '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );
                
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .section-title h2',
            ]
        );
    
        $this->add_control(
            'color_decriptions', [
                'label' => esc_html__( 'Text Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-content-05 p' => 'color: {{VALUE}};',
                ],
            ]
        );
        
         $this->add_control(
            'about_content_one', [
                'label' => esc_html__( 'Box Heading Text Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-content-05 h4' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'about_content_two', [
                'label' => esc_html__( 'Dots Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-active .slick-dots li.slick-active button' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .services-content-05 a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .hover-underline-animation::after' => 'background: {{VALUE}};',
                ],
            ]
        );

    
        $this->end_controls_section();
        
	}

	protected function render( $instance = [] ) {

		dahotel_el()->get_section('service-two', [
            
			'text_heading' => $this->get_settings('text_heading'),
			'posts_per_page' => $this->get_settings('posts_per_page'),

			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_service_two_box() );