<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_testimonial extends Widget_Base {

	public function get_name() {
		return 'Elementor-testimonial';
	}

	public function get_title() {
		return esc_html__( 'Zc >  Testimonial' ,'dahotel' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \dahotel_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Testimonials','dahotel'),]
		);
        
        
         $this->add_control(

            'back_img',

            [
                'label' => esc_html__( 'Background Image' ,'dahotel'),
                'type' => Controls_Manager::MEDIA,
            ]
            );
        $this->add_control(

            'sub_heading',

            [
                'label' => esc_html__( 'Sub Heading' ,'dahotel'),
                'type' => Controls_Manager::TEXT,
            ]
            );
        $this->add_control(

            'text_heading',

            [
                'label' => esc_html__( 'Text Heading' ,'dahotel'),
                'type' => Controls_Manager::TEXT,
            ]
            );
        $this->add_control(

            'text_description',

            [
                'label' => esc_html__( 'Description' ,'dahotel'),
                'type' => Controls_Manager::TEXT,
            ]
            );
        
         				
		

        $repeater = new \Elementor\Repeater();

         $repeater->add_control(
            'avtar',
            [
                'label' => esc_html__( 'Avatar imag', 'dahotel' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'review',
            [
                'label' => esc_html__( 'Review Image', 'dahotel' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,                
            ]
        );
        $repeater->add_control(
            'name',
            [
                'label' => esc_html__( 'Name Text', 'dahotel' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Insurance Police',
            ]
        );
        $repeater->add_control(
            'position',
            [
                'label' => esc_html__( 'Position Text', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Insurance Police',
            ]
        );
        
         $repeater->add_control(
            'description',
            [
                'label' => esc_html__( 'Description Text', 'dahotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Nullam egestas eros et nulla tempus, vel tempor neque scelerisque. Morbi eleifend convallis turpis, ac scelerisque.',
            ]
        );

      
        $this->add_control(
            'testimonial_repeater',
            [
                'label' => esc_html__( 'All Slides', 'dahotel' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                          'heading'   => 'Insurance Police',
                    ],
                   
                ],
                'title_field' => '{{{heading}}}'
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'slide_items_style', [
                'label' => esc_html__( 'Skill Style', 'dahotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Heading Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-area h2' => 'color: {{VALUE}};',
                ],
            ]
        );
                
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .testimonial-area h2',
            ]
        );
    
        $this->add_control(
            'color_decriptions', [
                'label' => esc_html__( 'Decriptions Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-testimonial p' => 'color: {{VALUE}};',
                ],
            ]
        );        
        
         $this->add_control(
            'color_name', [
                'label' => esc_html__( 'Name Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-active .ta-info h6' => 'color: {{VALUE}};',
                ],
            ]
        );        
        $this->add_control(
            'color_postions', [
                'label' => esc_html__( 'Postions Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-active .ta-info span' => 'color: {{VALUE}};',
                ],
            ]
        );       
        $this->add_control(
            'color_bigtext', [
                'label' => esc_html__( 'Big Text Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-area .text-bg h2' => 'color: {{VALUE}};',
                ],
            ]
        );        
    
        $this->add_control(
            'about_content_two', [
                'label' => esc_html__( 'Dots Background Color', 'dahotel' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                   '{{WRAPPER}} .testimonial-active .slick-dots .slick-active button' => 'background: {{VALUE}};',
                ],
            ]
        );

    
        $this->end_controls_section();
		
	}

	protected function render( $instance = [] ) {

		dahotel_el()->get_section('testimonial', [
            
			'testimonial_repeater' => $this->get_settings('testimonial_repeater'), 
			'column_section_data' => $this->get_settings('column_section'),
			'hading_section_data' => $this->get_settings('heading-text'),
			'back_img' => $this->get_settings('back_img'),
			'test_img' => $this->get_settings('test_img'),
            'text_heading' => $this->get_settings('text_heading'),                          
            'sub_heading' => $this->get_settings('sub_heading'),                          
            'text_description' => $this->get_settings('text_description'),                          
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_testimonial() );