<?php
/**
 * Post metaboxes configuration
 *
 * @package  dahotel.
 */

add_filter( 'rwmb_meta_boxes', 'dahotelzc_register_meta_boxes' );
function dahotelzc_register_meta_boxes( $meta_boxes ) {
    $prefix = 'dahotelzc_';
	$meta_boxes[] = array(
        'id'         => 'Quote',
        'title'      => esc_html__( 'Post Quote', 'dahotel' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Quote', 'dahotel' ),
                'desc'  => esc_html__( 'Quote Text Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_quote',
                 'type'    => 'textarea',
            ),
        )
    );
	$meta_boxes[] = array(
        'id'         => 'Link',
        'title'      => esc_html__( 'Post Link', 'dahotel' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Link', 'dahotel' ),
                'desc'  => esc_html__( 'Link Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_link',
                 'type'    => 'text',
            ),
        )
    );
    $meta_boxes[] = array(
        'id'         => 'blog-sections',
        'title'      => esc_html__( 'Post Gallery', 'dahotel' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(
            array(
                'name'  => esc_html__( 'Gallery', 'dahotel' ),
                'desc'  => '',
                'id'    => $prefix . 'post_gallery',
                'type'             => 'image_advanced',

				// Delete file from Media Library when remove it from post meta?
				// Note: it might affect other posts if you use same file for multiple posts
				'force_delete'     => false,

				// Maximum file uploads.
				'max_file_uploads' => 10,

				// Do not show how many files uploaded/remaining.
				'max_status'       => 'false',

				// Image size that displays in the edit page.
				'image_size'       => 'thumbnail',
            ),
			
        )
    );
	$meta_boxes[] = array(
        'id'         => 'video-sections',
        'title'      => esc_html__( 'Post Video', 'dahotel' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Video', 'dahotel' ),
                'desc'  => esc_html__( 'Youtube & Viemo Url Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_video',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
	$meta_boxes[] = array(
        'id'         => 'audio-sections',
        'title'      => esc_html__( 'Post Audio', 'dahotel' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Audio', 'dahotel' ),
                'desc'  => esc_html__( 'Soundcloud Embed Ifram Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_audio',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
	


      $meta_boxes[] = array(
        'id'         => 'Banner',
        'title'      => esc_html__( 'Banner Img', 'dahotel' ),
        'post_types' => 'portfolio',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Banner Img', 'dahotel' ),
                'desc'  => esc_html__( 'Banner Img Text Here', 'dahotel' ),
                'id'    => $prefix . 'post_banner',
                 'type'    => 'image_advanced',
            ),
        )
    );
	
	$meta_boxes[] = array(
        'id'         => 'team-postions-sections',
        'title'      => esc_html__( 'Team Post', 'dahotel' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Team Post', 'dahotel' ),
                'desc'  => esc_html__( 'Text Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_team_postions',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'team-social-sections',
        'title'      => esc_html__( 'Team Social Icons', 'dahotel' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Team Social', 'dahotel' ),
                'desc'  => esc_html__( 'Text Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_social',
                'type'  => 'textarea',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'team-social-single-sections',
        'title'      => esc_html__( 'Team Info Text', 'dahotel' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Team Info', 'dahotel' ),
                'desc'  => esc_html__( 'Text Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_single_social',
                'type'  => 'textarea',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'service-icon-sections',
        'title'      => esc_html__( 'Service Icons', 'dahotel' ),
        'post_types' => 'service',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Service Icon', 'dahotel' ),
                'desc'  => esc_html__( 'Icon Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_single_sicon',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'service-image-sections',
        'title'      => esc_html__( 'Service Image', 'dahotel' ),
        'post_types' => 'service',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Service Image', 'dahotel' ),
                'desc'  => esc_html__( 'Image Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_single_img',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'room-small-box',
        'title'      => esc_html__( 'Room Small Box', 'dahotel' ),
        'post_types' => 'zcroom',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(    
            array(
                'name'  => esc_html__( 'Room Per Night Price', 'dahotel' ),
                'desc'  => esc_html__( 'Text Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_single_price',
                'type'  => 'text',

				// Input size
				'size'  => 50,
            ),
            array(
                'name'  => esc_html__( 'Booking Text', 'dahotel' ),
                'desc'  => esc_html__( 'Text Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_single_booking',
                'type'  => 'textarea',

				// Input size
				'size'  => 50,
            ),
			 array(
                'name'  => esc_html__( 'Room Icon', 'dahotel' ),
                'desc'  => esc_html__( 'Icon Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_single_roomicon',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'room-single-page',
        'title'      => esc_html__( 'Room Single page', 'dahotel' ),
        'post_types' => 'zcroom',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(    
            array(
                'name'  => esc_html__( 'Galley Room Image', 'dahotel' ),
                'desc'  => esc_html__( 'Icon Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_single_img',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 50,
            ),
             array(
                'name'  => esc_html__( 'Galley Room Image Repater', 'dahotel' ),
                'desc'  => esc_html__( 'Icon Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_single_img_two',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 50,
            ),
             array(
                'name'  => esc_html__( 'Rating Star Image', 'dahotel' ),
                'desc'  => esc_html__( 'Icon Add Here', 'dahotel' ),
                'id'    => $prefix . 'post_star_rating',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 50,
            ),
           		 
        )
    );
   
    // Add more meta boxes if you want
    // $meta_boxes[] = ...

    return $meta_boxes;
}