<?php
/**
 * Displays Audio Post Format Content
 *
 * @package dahotel
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

   <div class="bsingle__post mb-50">
        <div class="bsingle__post-thumb">
            <?php						
                $media = rwmb_meta( 'dahotelzc_post_audio' );
                echo html_entity_decode ($media);
            ?>
        </div>
        <div class="bsingle__content">
            
            <div class="meta-info">
                <ul>
                     <li><i class="far fa-user"></i> <?php esc_html_e( 'By', 'dahotel' ); ?> <?php the_author(); ?>  </li>
                    <li><i class="fa-light fa-calendar-days"></i> <?php echo get_the_date(); ?> </li>
                    <li><i class="far fa-comments"></i> <?php comments_number( esc_html__('No Comments', 'dahotel'), esc_html__('Comment 1', 'dahotel'), esc_html__('Comments %', 'dahotel') ); ?> </li>
                </ul>
            </div>

            <?php
                if ( is_singular() ) :
                    the_title( '<h2 class="single">', '</h2>' );
                else :
                    the_title( '<h2 class="single"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                endif;

                if ( 'post' === get_post_type() ) :
                ?>

                <?php endif; ?>

                <?php if (is_single() ) {
                the_content();

            } elseif ( is_search() OR is_archive() ) {?>
                <p>
                    <?php echo substr(get_the_excerpt(), 0 ,180); ?>

                                </p>

                    <?php } else {
                if ($post) { ?>

                    <p>
                        <?php echo substr(get_the_excerpt(), 0 ,190); ?>	

                    </p>
                    <div class="blog-btn"><a href="<?php the_permalink() ?>"><?php esc_html_e( 'Read More', 'dahotel' ); ?></a></div>

                    <?php } else {
                    the_content();

                }

            } ?>


        </div>
    </div>
    
    