<?php
/**
 * Template part for Header Top Bar.
 *
 * @package dahotel
 */

$dahotel_data =get_option('dahotel_data'); 
?>  

<div class="container-fluid">
         <div class="row">
            <div class="col-xl-2 col-lg-3 pl-0 pr-0">
                 <!-- header -->
               <header class="header-slidemenu">
                  <div class="logo mb-100">
                    <!-- LOGO IMAGE -->
                        <!-- For Retina Ready displays take a image with double the amount of pixels that your image will be displayed (e.g 268 x 60 pixels) -->
                        <?php if(isset ($dahotel_data['dahotel__opt-logo-standard']['url']) && $dahotel_data['dahotel__opt-logo-standard']['url'] !== "") { ?>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="navbar-brand logo-black">
                        <!-- Logo Standard -->
                        <img src="<?php echo esc_url( $dahotel_data['dahotel__opt-logo-standard']['url'] ); ?>" alt="<?php echo esc_attr( get_bloginfo('name') ); ?>" title="<?php echo esc_attr( get_bloginfo('description') ); ?>" />
                         </a>
                        <?php } else { ?>
                        <!-- Logo Text Default -->
                        <h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                        <?php } ?>
                  </div>
                  <div class="main-menu slide-out">
                       <nav id="mobile-menu">
                                <?php
                            wp_nav_menu([
                                 'theme_location'  => 'main-menu',
                                  'container_id' => 'cssmenu', 										
                            ]);
                          ?>
                        </nav>
                  </div>
                  <div class="mobile-menu"></div>
                  <div class="footer-social">    
                      <?php if ( $dahotel_data['dahotel_opt-header-top-bar-social'] == 1) { ?>     
                                <?php echo html_entity_decode($dahotel_data['dahotel_opt-header-top-social'] ); ?>
                            <?php } ?>
                  </div>
               </header>
               <!-- header end -->
             </div>
            
